local pn=...;
local p=(pn==PLAYER_1) and 1 or 2;
local t=Def.ActorFrame{};

-- [ja] ターゲットスコア 
local target='Off';
if GAMESTATE:IsPlayerEnabled(pn) then
	local nm=ToEnumShortString(pn);
	if PROFILEMAN:GetNumLocalProfiles()>0
		and (PROFILEMAN:GetProfile(PLAYER_1):GetDisplayName() ~= PROFILEMAN:GetProfile(PLAYER_2):GetDisplayName()) then
		for i=1,PROFILEMAN:GetNumLocalProfiles() do
			if PROFILEMAN:GetProfile(pn):GetDisplayName()==PROFILEMAN:GetLocalProfileFromIndex(i-1):GetDisplayName() then
				nm="["..PROFILEMAN:GetLocalProfileIDFromIndex(i-1).."]";
				break
			end;
		end;
	end;
	target=GetUserPref_Theme("UserTarget"..nm);
	if not target then target='Off' end;
end;
local target_sx=256;
local target_cnt=0;
local target_hi;
local target_total=0;
local target_hidp;
local target_dp;
local target_per;
local target_rev;
local target_pss;
if target=="On" then
	--if GAMESTATE:IsPlayerEnabled(pn) and PROFILEMAN:IsPersistentProfile(pn) then
	if GAMESTATE:IsPlayerEnabled(pn) then
		t[#t+1]=Def.ActorFrame{
			CodeMessageCommand=function(self,params)
				if not getenv("Drill") or getenv("DrillRealTimeOpt") then
					if params.PlayerNumber==pn then
						if params.Name == "ScrollNomal" then
							target_rev=false;
							self:playcommand("Set");
						elseif params.Name == "ScrollReverse" then
							target_rev=true;
							self:playcommand("Set");
						end;
					end;
				end;
			end;
			-- [ja] 毎回呼ぶと重いのでグローバル変数に記録 
			BeginCommand=function(self)
				if not GAMESTATE:IsCourseMode() then
					local pf;
					if nm==""..ToEnumShortString(pn) then
						pf=PROFILEMAN:GetMachineProfile();
					else
						if PROFILEMAN:IsPersistentProfile(pn) then
							-- player profile
							pf=PROFILEMAN:GetProfile(pn);
						else
							-- machine profile
							pf=PROFILEMAN:GetMachineProfile();
						end;
					end;
					target_hi=pf:GetHighScoreList(_SONG(),GAMESTATE:GetCurrentSteps(pn)):GetHighScores();
					target_total=yaGetRD(pn,'RadarCategory_TapsAndHolds')+yaGetRD(pn,'RadarCategory_Holds')+yaGetRD(pn,'RadarCategory_Rolls');
					target_pss=STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
				else
					local trail = GAMESTATE:GetCurrentTrail(pn);
					local tr_ent = trail:GetTrailEntries()
					local tr_max = #tr_ent;
					target_hi=PROFILEMAN:GetProfile(pn):GetHighScoreList(GAMESTATE:GetCurrentCourse(),trail):GetHighScores();
					for i=1,tr_max do
						local rv=tr_ent[i]:GetSteps():GetRadarValues(pn);
						target_total=target_total+rv:GetValue('RadarCategory_TapsAndHolds')+rv:GetValue('RadarCategory_Holds')+rv:GetValue('RadarCategory_Rolls');
					end;
				end;
				target_hidp=GetScoreData(target_hi,"dp");
			end;
			JudgmentMessageCommand = function(self, params)
				if params.Player==pn and params.TapNoteScore and
				   params.TapNoteScore ~= 'TapNoteScore_Invalid' and
				   params.TapNoteScore ~= 'TapNoteScore_AvoidMine' and
				   params.TapNoteScore ~= 'TapNoteScore_HitMine' and
				   params.TapNoteScore ~= 'TapNoteScore_CheckpointMiss' and
				   params.TapNoteScore ~= 'TapNoteScore_CheckpointHit' and
				   params.TapNoteScore ~= 'TapNoteScore_None' then
					self:stoptweening();
					self:sleep(0.02);
					target_cnt=target_cnt+1;
					local pss=STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
					local w1=pss:GetTapNoteScores('TapNoteScore_W1');
					local w2=pss:GetTapNoteScores('TapNoteScore_W2');
					local w3=pss:GetTapNoteScores('TapNoteScore_W3');
					local hd=pss:GetHoldNoteScores('HoldNoteScore_Held');
					if GetSMVersion()>=3 then
						if (GAMESTATE:GetPlayerState(pn):GetPlayerController()~='PlayerController_Autoplay') then
							if params.HoldNoteScore=='HoldNoteScore_Held' then
								hd=hd+1;
							elseif params.TapNoteScore=='TapNoteScore_W1' then
								w1=w1+1;
							elseif params.TapNoteScore=='TapNoteScore_W2' then
								w2=w2+1;
							elseif params.TapNoteScore=='TapNoteScore_W3' then
								w3=w3+1;
							end;
						end;
					else	--[ja] A1a用
						if params.HoldNoteScore=='HoldNoteScore_Held' then
							hd=hd+1;
						elseif params.TapNoteScore=='TapNoteScore_W1' then
							w1=w1+1;
						elseif params.TapNoteScore=='TapNoteScore_W2' then
							w2=w2+1;
						elseif params.TapNoteScore=='TapNoteScore_W3' then
							w3=w3+1;
						end;
					end;
					target_dp=(w1*3+w2*2+w3+hd*3)/(target_total*3);
					target_per=(target_dp-(target_hidp*target_cnt/target_total))*100;
					self:queuecommand("TargetScore");
				end;
			end;
			OnCommand=function(self)
				self:zoomy(0);
				target_rev=IsReverse(pn);
				if not target_rev then
					self:y(SCREEN_CENTER_Y+THEME:GetMetric("Player","ReceptorArrowsYStandard")+55);
				else
					self:y(SCREEN_CENTER_Y+THEME:GetMetric("Player","ReceptorArrowsYReverse")-70);
				end;
				self:sleep(0.5);
				self:linear(0.3);
				self:zoomy(1);
			end;
			SetCommand=function(self)
				self:finishtweening();
				self:zoomy(1);
				self:linear(0.1);
				if not target_rev then
					self:y(SCREEN_CENTER_Y+THEME:GetMetric("Player","ReceptorArrowsYStandard")+55);
				else
					self:y(SCREEN_CENTER_Y+THEME:GetMetric("Player","ReceptorArrowsYReverse")-70);
				end;
			end;
			
			Def.Quad{
				InitCommand=cmd(zoomto,target_sx+2,20;horizalign,left;x,-target_sx/2-1;diffuse,0,0,0,0.5;);
			};
			Def.Quad{
				InitCommand=cmd(zoomto,target_sx/3+2,16;horizalign,left;y,18;x,target_sx/6-1;diffuse,0,0,0,0.5;);
			};
			Def.Quad{
				InitCommand=cmd(zoomto,target_sx,18;horizalign,left;x,-target_sx/2;diffuse,1,1,1,0.5;);
				OnCommand=function(self)
					self:zoomx(0);
					self:zoomy(18);
				end;
				TargetScoreCommand = function(self)
					self:stoptweening();
					self:zoomx(target_sx*(target_hidp*target_cnt/target_total));
					self:zoomy(18);
				end;
				OffCommand=function(self)
					self:zoomx(target_sx*(target_hidp*target_cnt/target_total));
					self:zoomy(18);
				end;
			};
			Def.Quad{
				InitCommand=cmd(zoomto,0,18;horizalign,left;x,-target_sx/2;diffuse,PlayerColor(pn););
				TargetScoreCommand = function(self, param)
					self:stoptweening();
					self:zoomx(target_sx*target_dp);
					self:zoomy(18);
					self:diffusealpha(0.5);
				end;
			};
			LoadFont("Common Normal")..{
				InitCommand=function(self)
					(cmd(zoom,0.8;x,target_sx/2-42;y,-1;
						diffuse,0.8,0.8,0.8,1;strokecolor,Color("Outline");))(self);
						self:settextf("%4.2f%%",0);
				end;
				TargetScoreCommand = function(self)
					self:stoptweening();
					local add_ch="";
					if target_per<-0.0081 then
						self:diffuse(ColorLightTone(Color("Red")));
						add_ch="";
					elseif target_per>0.0081 then
						self:diffuse(ColorLightTone(Color("Blue")));
						add_ch="+";
					else
						self:diffuse(0.8,0.8,0.8,1);
						add_ch=" ";
					end;
					self:settextf("%4.2f%%",target_dp*100);
					self:zoom(1.0);
					self:linear(0.02);
					self:zoom(0.8);
				end;
			};
			LoadFont("Common Normal")..{
				InitCommand=function(self)
					(cmd(zoom,0.7;x,target_sx/2-42;y,15;
						diffuse,0.8,0.8,0.8,1;strokecolor,Color("Outline");))(self);
						self:settextf("%4.2f%%",0);
				end;
				TargetScoreCommand = function(self)
					self:stoptweening();
					local add_ch="";
					if target_per<-0.0081 then
						self:diffuse(ColorLightTone(Color("Red")));
						add_ch="";
					elseif target_per>0.0081 then
						self:diffuse(ColorLightTone(Color("Blue")));
						add_ch="+";
					else
						self:diffuse(0.8,0.8,0.8,1);
						add_ch=" ";
					end;
					self:settextf("%s%4.2f%%",
						add_ch,target_per);
					self:zoom(1.0);
					self:linear(0.02);
					self:zoom(0.7);
				end;
			};
		};
	end;
end;

return t;
